%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Integrated design with UIO"
% Jianglin Lan, Feb 12th, 2015, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = Proposed_Closed_sys(t,xx, A, B, C, D1, D2, F, K, N, J, L, W, H, Ud, Vd, P, Q,C_bar, sigma0, delta,tau)

X = xx(1:3);
Z = xx(4:7);
hat_rho = xx(8);
veq = xx(9:11);

global Intd_ts Intd_count Intd_tmp
global Intd_hatf1 Intd_hatx1 Intd_hatx2 Intd_hatx3 
global Intd_hatd1 Intd_hatd2 Intd_f1 
global Intd_ey1 Intd_ey2 Intd_ey3

f = 0.5 + 1 * sin(2.5*pi*t); % fault
da = 0.5 * cos(2.5*t) + cos(2*t)*0.2*sin(X(1))*cos(X(2)); % actuator attack
ds = cos(pi*t);  % sensor attack
d = [ds;da];

% controller
u = -K*X;

% observer
y = Ud'*(C*X + D2*d);
hat_chi = Z + H*y;
hat_y = C_bar*hat_chi;

hat_X = hat_chi(1:3);
hat_d10 = hat_chi(4);

hat_d20 = inv(Q'*C_bar*inv(P)*C_bar'*Q)*Q'*C_bar*inv(P)*C_bar'*veq;
hat_f = hat_d20(1);
hat_d = Vd*[hat_d10; hat_d20(2)];

ey = y - hat_y;
rho_v = hat_rho + delta;

v = rho_v*ey/(norm(ey, 2) +  tau);

dot_Z = N*Z + J*u + L*y + W*v;

dot_hat_rho = sigma0*norm(ey, 2); 
dot_veq = 1/tau *(-veq + v);

% sys dynamic
dot_X = A*X + B*u + F*f + D1*d;

% % data saving 
if mod(Intd_tmp,2)==0
    Intd_count = Intd_count + 1;
Intd_ts(Intd_count) = t;
Intd_f1(Intd_count) = hat_f;
Intd_hatf1(Intd_count) = f - hat_f;
Intd_hatx1(Intd_count) = X(1) - hat_X(1);
Intd_hatx2(Intd_count) = X(2) - hat_X(2);
Intd_hatx3(Intd_count) = X(3) - hat_X(3);
Intd_hatd1(Intd_count) = ds - hat_d(1);
Intd_hatd2(Intd_count) = da - hat_d(2);
Intd_ey1(Intd_count) = ey(1);
Intd_ey2(Intd_count) = ey(2);
Intd_ey3(Intd_count) = ey(3);
end
Intd_tmp = Intd_tmp + 1;

sys_state = [dot_X; dot_Z; dot_hat_rho; dot_veq];